<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Ana Menü Düzenle'); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/animate-css/animate.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/cleavejs/cleave.js')); ?>"></script>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '<?php echo e(session('success')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>

<?php elseif(session('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?php echo e(session('error')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>
<?php endif; ?>

<?php $__env->startSection('content'); ?>

<h4> <?php echo e($data->name); ?> Ana Menüsünü Düzenle</h4>

<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('ana_menu.update', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="mb-3">
                        <label for="adi" class="form-label">Adı</label>
                        <input type="text" class="form-control" id="name" name="name" value="<?php echo e($data->name ?? old('name')); ?>">
                    </div>
                    <div class="mb-3">
                        <label for="link" class="form-label">Resim</label>
                        <input type="file" class="form-control" id="image" name="image" value="<?php echo e($data->image ?? old('image')); ?>">
                    </div>
                    <div class="mb-3">
                        <label for="sira" class="form-label">Sıra</label>
                        <input type="text" class="form-control" id="sira" name="sira" value="<?php echo e($data->sira ?? old('sira')); ?>">
                    </div>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/baristeksin/web/75simdo.dijimenu.com.tr/public_html/resources/views/admin/ana_menu/edit.blade.php ENDPATH**/ ?>