<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>75 Simdo Menü</title>
    <link rel="stylesheet" href="{{ asset('assets/custom/category.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
</head>

<body>

    <div class="container">
        <div class="header">
            <h1 class="display-1 text-center fw-bold">{{$menu_adi->name}} Çeşitlerimiz</h1>
        </div>
        <div class="row row-cols-1 row-cols-md-3 g-4 menu">
            @foreach($menus as $menu)
            <div class="col">
                <div class="card">
                    <img src="{{ asset('storage/' . $menu->image) }}"
                        class="card-img-top" alt="{{$menu->name}}">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-center flex-column">
                            <h3 class="card-title fw-bold">{{$menu->name}}</h3>
                            <p class="card-text">{{$menu->kisa_aciklama}}</p>
                            <h5 class="card-text center fw-bold btn btn-outline-info mt-2 waves-effect">Fiyat: {{$menu->fiyat}}</h5>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach

        </div>
    </div>
</body>

</html>