@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Ayar Göster')

@section('content')
<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>{{ $ayar->key}} Ayarı</h4>
                <br>
                <p>{{ $ayar->description }}</p>
            </div>
            <div class="card-body">
                @if ($ayar->type == 'image')
                <img src="{{ asset('storage/' . $ayar->value) }}" alt="{{ $ayar->value }}" class="img-fluid">
                @else
                <input type="text" class="form-control" value="{{ $ayar->value }}" readonly>
                @endif
                <br>
                <a href="{{ route('ayarlar.index') }}" class="btn btn-primary mt-4">Geri Dön</a>
                <a href="{{ route('ayarlar.edit', $ayar->id) }}" class="btn btn-warning mt-4">Düzenle</a>
            </div>
        </div>
    </div>
</div>
@endsection