<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AnaMenu;
use App\Models\AltMenu;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File as FacadesFile;

class AnaMenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $ana_menus = AnaMenu::orderBy('sira');
        $ana_menu_count = AnaMenu::count();

        $search_data = array();
        if ($request->has('arama')){
            $search_data['arama'] = $request->input('arama');
            $ana_menus = $ana_menus->where('name', 'like', '%'.$search_data['arama'].'%');
        }
        $ana_menus = $ana_menus->where('id', '>', 0);
        $ana_menus = $ana_menus->paginate(10);
        return view('admin.ana_menu.index', compact('ana_menus', 'ana_menu_count', 'search_data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.ana_menu.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'  => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:2048',
            'sira'  => 'required|numeric',
        ]);
        $file = $request->file('image');
        if ($request->hasFile('image')) {
            $profile_photo_path = bin2hex(random_bytes(32));
            $file_name = $profile_photo_path . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put($file_name, FacadesFile::get($file));
        }else{
            return redirect()->back()->with('error', 'Resim yüklenemedi.');
        }
        $ana_menu = new AnaMenu();
        $ana_menu->name = $request->name;
        $ana_menu->image = $file_name;
        $ana_menu->sira = $request->sira;
        $ana_menu->save();
        return redirect()->route('ana_menu.index')->with('success', 'Ana menü başarıyla eklendi.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $data = AnaMenu::findOrFail($id);
        return view('admin.ana_menu.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $data = AnaMenu::findOrFail($id);
        return view('admin.ana_menu.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name'  => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:2048',
            'sira'  => 'required|numeric',
        ]);

        $ana_menu = AnaMenu::findOrFail($id);
        $ana_menu->name = $request->name;
        $ana_menu->sira = $request->sira;
        if ($request->hasFile('image')) {
            if (Storage::disk('public')->exists($ana_menu->image)) {
                Storage::disk('public')->delete($ana_menu->image);
            }
            $file = $request->file('image');
            $profile_photo_path = bin2hex(random_bytes(32));
            $file_name = $profile_photo_path . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put($file_name, FacadesFile::get($file));
            $ana_menu->image = $file_name;
        }
        $ana_menu->save();
        return redirect()->route('ana_menu.index')->with('success', 'Ana menü başarıyla güncellendi.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $data = AnaMenu::findOrFail($id);
        $data->delete();
        if (Storage::disk('public')->exists($data->image)) {
            Storage::disk('public')->delete($data->image);
        }
        $alt_menus = AltMenu::where('ana_menu_id', $id)->get();
        foreach ($alt_menus as $alt_menu) {
            $alt_menu->ana_menu_id = 0;
            $alt_menu->save();
        }
        return redirect()->route('ana_menu.index')->with('success', 'Ana menü başarıyla silindi.');
    }
}
